﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Core;

namespace Mdws2ORM.Maps.BaseFields
{
    public class FieldMap<T> : BaseFieldMap<T>
         where T : class
    {
        private readonly Action<T, string> MapAction;

        public FieldMap(string field, Action<T, string> mapAction)
            : base(field)
        {
            MapAction = mapAction;
        }

        public override void Map(IEntityQuery query, T entity, string value)
        {
            MapAction(entity, value);
        }
    }
}
